<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Api\V2010\Account;

use Twilio\ListResource;
use Twilio\Version;

class SandboxList extends ListResource {
    /**
     * Construct the SandboxList
     * 
     * @param Version $version Version that contains the resource
     * @param string $accountSid The account_sid
     * @return \Twilio\Rest\Api\V2010\Account\SandboxList 
     */
    public function __construct(Version $version, $accountSid) {
        parent::__construct($version);
        
        // Path Solution
        $this->solution = array(
            'accountSid' => $accountSid,
        );
    }

    /**
     * Constructs a SandboxContext
     * 
     * @return \Twilio\Rest\Api\V2010\Account\SandboxContext 
     */
    public function getContext() {
        return new SandboxContext(
            $this->version,
            $this->solution['accountSid']
        );
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        return '[Twilio.Api.V2010.SandboxList]';
    }
}