<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Api\V2010\Account;

use Twilio\Options;
use Twilio\Values;

abstract class SandboxOptions {
    /**
     * @param string $voiceUrl The voice_url
     * @param string $voiceMethod The voice_method
     * @param string $smsUrl The sms_url
     * @param string $smsMethod The sms_method
     * @param string $statusCallback The status_callback
     * @param string $statusCallbackMethod The status_callback_method
     * @return UpdateSandboxOptions Options builder
     */
    public static function update($voiceUrl = Values::NONE, $voiceMethod = Values::NONE, $smsUrl = Values::NONE, $smsMethod = Values::NONE, $statusCallback = Values::NONE, $statusCallbackMethod = Values::NONE) {
        return new UpdateSandboxOptions($voiceUrl, $voiceMethod, $smsUrl, $smsMethod, $statusCallback, $statusCallbackMethod);
    }
}

class UpdateSandboxOptions extends Options {
    /**
     * @param string $voiceUrl The voice_url
     * @param string $voiceMethod The voice_method
     * @param string $smsUrl The sms_url
     * @param string $smsMethod The sms_method
     * @param string $statusCallback The status_callback
     * @param string $statusCallbackMethod The status_callback_method
     */
    public function __construct($voiceUrl = Values::NONE, $voiceMethod = Values::NONE, $smsUrl = Values::NONE, $smsMethod = Values::NONE, $statusCallback = Values::NONE, $statusCallbackMethod = Values::NONE) {
        $this->options['voiceUrl'] = $voiceUrl;
        $this->options['voiceMethod'] = $voiceMethod;
        $this->options['smsUrl'] = $smsUrl;
        $this->options['smsMethod'] = $smsMethod;
        $this->options['statusCallback'] = $statusCallback;
        $this->options['statusCallbackMethod'] = $statusCallbackMethod;
    }

    /**
     * The voice_url
     * 
     * @param string $voiceUrl The voice_url
     * @return $this Fluent Builder
     */
    public function setVoiceUrl($voiceUrl) {
        $this->options['voiceUrl'] = $voiceUrl;
        return $this;
    }

    /**
     * The voice_method
     * 
     * @param string $voiceMethod The voice_method
     * @return $this Fluent Builder
     */
    public function setVoiceMethod($voiceMethod) {
        $this->options['voiceMethod'] = $voiceMethod;
        return $this;
    }

    /**
     * The sms_url
     * 
     * @param string $smsUrl The sms_url
     * @return $this Fluent Builder
     */
    public function setSmsUrl($smsUrl) {
        $this->options['smsUrl'] = $smsUrl;
        return $this;
    }

    /**
     * The sms_method
     * 
     * @param string $smsMethod The sms_method
     * @return $this Fluent Builder
     */
    public function setSmsMethod($smsMethod) {
        $this->options['smsMethod'] = $smsMethod;
        return $this;
    }

    /**
     * The status_callback
     * 
     * @param string $statusCallback The status_callback
     * @return $this Fluent Builder
     */
    public function setStatusCallback($statusCallback) {
        $this->options['statusCallback'] = $statusCallback;
        return $this;
    }

    /**
     * The status_callback_method
     * 
     * @param string $statusCallbackMethod The status_callback_method
     * @return $this Fluent Builder
     */
    public function setStatusCallbackMethod($statusCallbackMethod) {
        $this->options['statusCallbackMethod'] = $statusCallbackMethod;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Api.V2010.UpdateSandboxOptions ' . implode(' ', $options) . ']';
    }
}