package main

import (
	"github.com/brutella/hc/hap"
	"github.com/brutella/hc/model"
	"github.com/brutella/hc/model/accessory"
	"net/http"
	"log"
	"io/ioutil"
	"encoding/xml"
)


type MyResp struct {
	XMLName		xml.Name
	Value		Value
	}

type Value struct {	
	XMLName		xml.Name `xml"LL"`
    Value       string `xml:"value,attr"`
    Control		string `xml:"control,attr"`
    Code        string `xml:"Code,attr"`
}

func main() {

	TVInfo := model.Info{
		Name: "TV Scene",
	}
	tv := accessory.NewSwitch(TVInfo)
	t, err := hap.NewIPTransport("03887210", tv.Accessory)

	if err != nil {
		log.Fatal(err)
	}
	// Log to console when client (e.g. iOS app) changes the value of the on characteristic
	tv.OnStateChanged(func(on bool) {
		status, err := http.Get("http://Username:Password@Loxone.DNS.OR.IP/dev/sps/io/VirtualStatus/state")
		log.Println("[INFO] Client changed flipped switch - Check status")
		log.Println(status)
		if err != nil {
			log.Fatal(err)
			}
		defer status.Body.Close()
		body, err := ioutil.ReadAll(status.Body)
		log.Printf("body %v", string(body))
		var c Value
     	xml.Unmarshal(body, &c)
		log.Println(c.Value)
		if on == true {
			log.Println("[INFO] Client changed switch to on")
			switch c.Value {
			case "1.0":
				log.Println("[INFO] Tv Scene allready set")
			default:
				log.Println("[INFO] Client changed switch to on - Send Pulse")
				resp, err := http.Get("http://Username:Password@Loxone.DNS.OR.IP/dev/sps/io/VirtualInput/Pulse")
				log.Println(resp)
				if err != nil {
					log.Fatal(err)
					}
				defer resp.Body.Close()
				}
		} else {
			log.Println("[INFO] Client changed switch to off")
			switch c.Value {
			case "0.0":
				log.Println("[INFO] Tv Scene allready off")
			case "-1.0":
				log.Println("[INFO] Other Scene Set")	
			case "1.0":
				log.Println("[INFO] Send Pulse to turn off scene")
				resp, err := http.Get("http://Username:Password@Loxone.DNS.OR.IP/dev/sps/io/VirtualInput/Pulse")
				log.Println(resp)
				if err != nil {
					log.Fatal(err)
					}
				defer resp.Body.Close()
			default:
				log.Println("[INFO] Other scene set turn off - Send Pulse")
				resp, err := http.Get("http://Username:Password@Loxone.DNS.OR.IP/dev/sps/io/VirtualInputForOff/Pulse")
				log.Println(resp)
				if err != nil {
					log.Fatal(err)
					}
				defer resp.Body.Close()
				}
		}
	})


	hap.OnTermination(func() {
		t.Stop()
	})

	t.Start()
}